/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jcodings.exception.InternalException;

public class ArrayReader {
    public static DataInputStream openStream(String name2) {
        String entry = "/tables/" + name2 + ".bin";
        InputStream is = ArrayReader.class.getResourceAsStream(entry);
        if (is == null) {
            throw new InternalException("entry: " + entry + " not found");
        }
        return new DataInputStream(new BufferedInputStream(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArray(String name2) {
        DataInputStream dis = ArrayReader.openStream(name2);
        try {
            int size2 = dis.readInt();
            byte[] bytes2 = new byte[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                bytes2[i2] = dis.readByte();
            }
            ArrayReader.checkAvailable(dis, name2);
            byte[] byArray = bytes2;
            return byArray;
        }
        catch (IOException ioe) {
            ArrayReader.decorate(ioe, name2);
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntArray(String name2) {
        DataInputStream dis = ArrayReader.openStream(name2);
        try {
            int size2 = dis.readInt();
            int[] ints = new int[size2];
            for (int i2 = 0; i2 < size2; ++i2) {
                ints[i2] = dis.readInt();
            }
            ArrayReader.checkAvailable(dis, name2);
            int[] nArray = ints;
            return nArray;
        }
        catch (IOException ioe) {
            ArrayReader.decorate(ioe, name2);
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readNestedIntArray(String name2) {
        DataInputStream dis = ArrayReader.openStream(name2);
        try {
            int size2 = dis.readInt();
            int[][] ints = new int[size2][];
            for (int i2 = 0; i2 < size2; ++i2) {
                int iSize = dis.readInt();
                int[] iints = new int[iSize];
                ints[i2] = iints;
                for (int k = 0; k < iSize; ++k) {
                    iints[k] = dis.readInt();
                }
            }
            ArrayReader.checkAvailable(dis, name2);
            int[][] nArrayArray = ints;
            return nArrayArray;
        }
        catch (IOException ioe) {
            ArrayReader.decorate(ioe, name2);
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    static void checkAvailable(DataInputStream dis, String name2) throws IOException {
        if (dis.available() != 0) {
            throw new InternalException("length mismatch for table: " + name2 + " (" + dis.available() + " left)");
        }
    }

    static void decorate(IOException ioe, String name2) {
        throw new InternalException("problem reading table: " + name2 + ": " + ioe);
    }
}

